/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.idl;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.idl.IDLSourceScanner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class IDLSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__idl__";
    public static final String DEFAULT = "__idl__dftl_partition_content_type";
    public static final String IDL_SINGLELINE_COMMENT = "__idl__singleline_comment";
    public static final String IDL_MULTILINE_COMMENT = "__idl__multiline_comment";
    public static final String IDL_DOC_COMMENT = "__idl__doc_comment";
    public static final String[] CONTENT_TYPES = new String[]{"__idl__dftl_partition_content_type", "__idl__multiline_comment", "__idl__singleline_comment", "__idl__doc_comment"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.idl"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new EndOfLineRule("//", IDLSourceConfiguration.getToken("__idl__singleline_comment")), new MultiLineRule("/**", "*/", IDLSourceConfiguration.getToken("__idl__doc_comment"), '\u0000', true), new MultiLineRule("/*", "*/", IDLSourceConfiguration.getToken("__idl__multiline_comment"), '\u0000', true)};
    private static IDLSourceConfiguration instance;

    private IDLSourceConfiguration() {
    }

    public static IDLSourceConfiguration getDefault() {
        if (instance == null) {
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.idl"}), new QualifiedContentType(new String[]{"source.idl"}));
            c.addTranslation(new QualifiedContentType(new String[]{IDL_SINGLELINE_COMMENT}), new QualifiedContentType(new String[]{"comment.line.double-slash.idl"}));
            c.addTranslation(new QualifiedContentType(new String[]{IDL_DOC_COMMENT}), new QualifiedContentType(new String[]{"comment.block.documentation.idl"}));
            c.addTranslation(new QualifiedContentType(new String[]{IDL_MULTILINE_COMMENT}), new QualifiedContentType(new String[]{"comment.block.idl"}));
            instance = new IDLSourceConfiguration();
        }
        return instance;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, IDLSourceConfiguration.getToken(DEFAULT));
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.idl";
        }
        return null;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer((ITokenScanner)new IDLSourceScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        ThemeingDamagerRepairer docCommentDR = new ThemeingDamagerRepairer((ITokenScanner)new CommentScanner(IDLSourceConfiguration.getToken("comment.block.documentation.idl")));
        reconciler.setDamager((IPresentationDamager)docCommentDR, IDL_DOC_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)docCommentDR, IDL_DOC_COMMENT);
        ThemeingDamagerRepairer multilineCommentDR = new ThemeingDamagerRepairer((ITokenScanner)new CommentScanner(IDLSourceConfiguration.getToken("comment.block.idl")));
        reconciler.setDamager((IPresentationDamager)multilineCommentDR, IDL_MULTILINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)multilineCommentDR, IDL_MULTILINE_COMMENT);
        ThemeingDamagerRepairer singlelineCommentDR = new ThemeingDamagerRepairer((ITokenScanner)new CommentScanner(IDLSourceConfiguration.getToken("comment.line.double-slash.idl")));
        reconciler.setDamager((IPresentationDamager)singlelineCommentDR, IDL_SINGLELINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)singlelineCommentDR, IDL_SINGLELINE_COMMENT);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new CommonContentAssistProcessor(editor);
    }
}

